/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import java.util.LinkedList;

public class VicTapeTrack {
    long max_counter = 0L;
    LinkedList<SignalEvent> event_list = new LinkedList();
    int current_read_index = 0;

    public void recordSignal(long counter, boolean signal) {
        this.event_list.add(new SignalEvent(counter, signal));
        if (counter > this.max_counter) {
            this.max_counter = counter;
        }
    }

    public boolean playSignal(long counter) {
        boolean signal = false;
        if (this.event_list.size() > 0) {
            if (this.event_list.get(this.current_read_index).getCounter() > counter) {
                if (this.current_read_index == 0) {
                    return signal;
                }
                this.current_read_index = 0;
            }
            while (this.event_list.get(this.current_read_index).getCounter() < counter) {
                if (this.current_read_index + 1 == this.event_list.size()) break;
                ++this.current_read_index;
            }
            signal = this.event_list.get(this.current_read_index).getSignal();
        }
        return signal;
    }

    public long getCount() {
        return this.max_counter;
    }

    class SignalEvent {
        private long counter;
        private boolean signal;

        public SignalEvent(long counter, boolean signal) {
            this.counter = counter;
            this.signal = signal;
        }

        public long getCounter() {
            return this.counter;
        }

        public void setCounter(long counter) {
            this.counter = counter;
        }

        public boolean getSignal() {
            return this.signal;
        }

        public void setSignal(boolean signal) {
            this.signal = signal;
        }
    }
}

